# This code performs approximate multiplication on two 4-bit numbers.
# It first takes i1 and i2 from user on command line.
# There is a .txt file attached which hold the product values in order (0x0, 1x0, ...., 15x0, 1x0, .........., 15x15)
# It then stores it accordingly in prod[] matrix
# According to input combination provided by user, it writes the corresponding in another file(.txt)
# The input and output filenames are generically taken as approx_4x4.txt and behavioural_4x4.txt from VHDL simulation
# You can rename them according to your multiplier module name

i1 = input("enter first number : ") 											# Input A (4-bit) in decimal
i2 = input("enter second number : ")											# Input B (4-bit) in decimal

with open("approx_4x4.txt", "r") as fh1:									# Opens text file containing all products in order in decimal (NAME IT ACCORDING TO YOUR FILENAME)
	fh2 = open("behavioural_4x4.txt", "w")									# Text file in which product would be written (NAME IT ACCORDING TO YOUR FILENAME)
	a = []
	b = []
	prod = []
	out = 0
	count = 0
	temp = 0
	fh1.seek(fh1.tell(),0)
	line = fh1.readline()
	while line:
		length = len(line)
		if length > 1:
			for i in range(length):
				b.append(int(i/16))											# Stores multiplier matrix
				a.append(int(i%16))											# Stores multiplicand matrix
			prod.append(line)													# Stores product matrix in order			
		count = count + 1
		line = fh1.readline()

	for i in range(len(prod)):
			if int(i%16) == int(i1) and int(i/16) == int(i2):
				fh2.write(str(int(prod[i])))									# Writes corresponding product of inputs provided by user in different text file


fh2.close()






















